<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
/*  Payslip PDF
*****************************************/
$page_security = 'SA_OPEN';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

if(!isset($_GET['payrol_inquiry']))
	print_payslip();

function print_payslip() {

	global $path_to_root, $systypes_array, $kv_empl_gender;

	if(isset($_GET['rep_v'])){
		include_once($path_to_root . "/modules/ExtendedHRM/includes/Payroll.inc");
	}
    $year = (isset($_POST['PARAM_0']) ? $_POST['PARAM_0'] : (isset($_GET['PARAM_0']) ? $_GET['PARAM_0'] : 1));
    $month = (isset($_POST['PARAM_1']) ? $_POST['PARAM_1'] : (isset($_GET['PARAM_1']) ? $_GET['PARAM_1'] : 01));
    $empl_id = (isset($_POST['PARAM_2']) ? $_POST['PARAM_2'] : (isset($_GET['PARAM_2']) ? $_GET['PARAM_2'] : 0));
	$comment = (isset($_POST['PARAM_3']) ? $_POST['PARAM_3'] : (isset($_GET['PARAM_3']) ? $_GET['PARAM_3'] : ''));;
    //$destination = (isset($_POST['PARAM_4']) ? $_POST['PARAM_4'] : (isset($_GET['PARAM_4']) ? $_GET['PARAM_4'] : ''));
    $_POST['REP_ID'] = 802; 

	if(db_has_employee_payslip($empl_id, $month, $year)){

		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

		$orientation = 'P';
		$dec = user_price_dec();
		
		$cols = array(10,215,290,480);	
		
		$headers = array(_("Earnings"), _(""), _("Deductions"), _(""));
		$aligns = array('left',	'right', 'left', 'right');

		$rep = new FrontReport(_("Payslip"), "Payslip", user_pagesize(), 9, $orientation);
		if(!function_exists('get_empl_sal_details_file')){
			function get_empl_sal_details_file($empl_id, $month, $year){
				$sql = "SELECT * FROM ".TB_PREF."kv_empl_salary	WHERE empl_id=".db_escape($empl_id)." AND month=".db_escape($month)." AND year=".db_escape($year);
				return db_query($sql,_("No transactions were returned"));
			}
		}	
		
		$result = get_empl_sal_details_file($empl_id, $month, $year);	
		
		if ($myrow = db_fetch($result))	{

			$name_and_dept = get_empl_name_dept($myrow['empl_id']);
			$kyc = GetRow('kv_empl_job',array('empl_id' => $myrow['empl_id']));
			//$dept_id=GetSingleValue('kv_empl_job','department' ,array('empl_id'=>$myrow['empl_id']));
			$dept_name=GetSingleValue('kv_empl_departments','description' ,array('id'=>$kyc['department']));
			$employee_info = array(
						'id' => $myrow['id'],
						'order_no' => $myrow['empl_id'],
						'name' => $name_and_dept['name'],
						'location_name' => $dept_name,
						'payment_terms' => kv_get_empl_desig($myrow['empl_id']),
						'ord_date' => sql2date(get_employee_join_date($myrow['empl_id'])),
						'date_' => $month,
						'tran_date' => sql2date($myrow['date']));
			$branch = array(										
						'br_address' => $kyc['ESIC'],										
						'br_name' => $kyc['PF'],										
						'salesman' => $kyc['PAN'],					
						'disable_branch' => $year );

			$baccount = get_empl_bank_acc_details($myrow['empl_id']);		
			$sql = "SELECT SUM(`al`) AS AL, SUM(`sl`) AS SL, SUM(`ml`) AS ML, COUNT(`month`) AS months FROM ".TB_PREF."kv_empl_salary WHERE   empl_id =".db_escape($empl_id)." AND year = ".$year." ";
			$res =  db_query($sql , _("Can't get result"));
			if($past_leave =  db_fetch_assoc($res))

				$leaves = GetRow('kv_empl_job', array('empl_id '=> $empl_id));		
				$AL = $SL = $ML = 0 ;
				// for($kv= 1; $kv<=31;$kv++ ){
				// 	if(isset($leaves[$kv]) && $leaves[$kv] == 'AL')
				// 		$AL++;
				// 	if(isset($leaves[$kv]) && $leaves[$kv] == 'SL')
				// 		$SL++;
				// 	if(isset($leaves[$kv]) && $leaves[$kv] == 'ML')
				// 		$ML++;
				// }
				$rep->SetHeaderType('PayrollHeader');	
				$rep->Font();
				$rep->Info(null, $cols, $headers, $aligns);
				$contacts = array( 
							'email' => $name_and_dept['email'],
							'name2'	=>	null,
							'name'  => 	$name_and_dept['name'],
							'lang'	=> null,
						);
				$rep->SetCommonData($employee_info, $branch, [], $baccount,  'payslip', array( $contacts));
				$rep->NewPage();
				$rep->Font('bold');
				$rep->TextCol(1, 2,	_("Amount"), -34,-91);
				$rep->TextCol(3, 4,	_("Amount"), -15,-91);			
				$rep->Font();  
				$rep->NewLine();		

				$text_value=40;
				$line_value=670;
				//display_error($rep->row);
							$earallows = $dedallows = array();
				$Allowance = kv_get_allowances(null, 0, $kyc['grade']);
				foreach($Allowance as $single){
					if($single['type'] == 'Earnings' )
						$earallows[] = $single;
					elseif($single['type'] == 'Reimbursement' )
						$earallows[] =  $single;
				//	elseif($single['type'] == 'Employer Contribution' )
					//	$earallows[] =  $single;
					//elseif($single['type'] == 'Employer Contribution' )
					//	$earallows[] =  $single;
					elseif($single['type'] == 'Deductions' )
						$dedallows[] =  $single;
				}
				$earnings_count = get_allowances_count('Earnings')+get_allowances_count('Reimbursement')+get_allowances_count('Employer Contribution') ;
				$deductions_count = get_allowances_count('Deductions');
				if($earnings_count > $deductions_count){
					$count_final  = $earnings_count;
				}else{
					$count_final = $deductions_count;
				} 
				$Value = -70;
				$total_deduction = 0;
				$count_difference = $count_final- $deductions_count;
				if($count_difference >= 2)
					$else_deduct = 0;
				else
					$else_deduct = 3;
				$ot_earnings = 1; 
				
				for($vj=0; $vj<$count_final;$vj++){
					$exist = false;
					if(isset($earallows[$vj])){
						$rep->Text($text_value+10, $earallows[$vj]['description'],0,0,$Value);
						$rep->TextCol(1,2, number_format2($myrow[$earallows[$vj]['id']], $dec), -25,-70);
						$exist = true;
					}elseif($ot_earnings){
						$rep->Text($text_value+10, _("OT"),0,0,$Value);
						$rep->TextCol(1,2, number_format2($myrow['ot_earnings'], $dec), -25,-70);
						$ot_earnings = 0;
						$exist = true;
					}
					if(isset($dedallows[$vj])){
						$rep->Text(330, $dedallows[$vj]['description'],0,0,$Value);
						$rep->TextCol(3,4,  number_format2($myrow[$dedallows[$vj]['id']], $dec), -5,-70);
						$total_deduction += $myrow[$dedallows[$vj]['id']];
						$exist = true;
					}
					/*elseif($else_deduct==0){
						$rep->Text(330, _("Loan Amount"),0,0,$Value);
						$rep->TextCol(3,4,  number_format2($myrow['loan'], $dec), -5,-70);
						$total_deduction += $myrow['loan'];
						$else_deduct++;
					}*/
					elseif($else_deduct==1){
						$rep->Text(330, _("LOP Amount"),0,0,$Value);
						$rep->TextCol(3,4,  number_format2($myrow['lop_amount'], $dec), -5,-70);
						$total_deduction += $myrow['lop_amount'];
						$else_deduct++;
						$exist = true;
					}		
					if($exist) {		
						$rep->NewLine(2);
						$Value++;		
					}		
				}
				
				$Value++;
				if($myrow['adv_sal'] > 0){
					$rep->Text(330, _("Advance"),0,0,$Value);
					$rep->TextCol(3,4, number_format2($myrow['adv_sal'], $dec), -5,-70);
					$total_deduction += $myrow['adv_sal'];
					$exist = true;
				}
				
				$rep->Font('bold');
				$rep->Text($text_value+10, _("Taken Leave"),0,0,-70);
				$rep->Text(330, _("Used Leave"),0,0,$Value);		
				$rep->Font();  
				$rep->NewLine(2);		
			
				$rep->Text($text_value+10, _("Annual Leave"),0,0,-70);
				$rep->Text(150, $leaves['al'],0,0,-70);			
				$rep->Text(330, _("Annual Leave"),0,0,$Value);
				$rep->Text(420, $past_leave['AL'],0,0,-70);
				$rep->NewLine();
				
				$rep->Text($text_value+10, _("Sick Leave"),0,0,-70);
				$rep->Text(150, $leaves['sl'],0,0,-70);			
				$rep->Text(330, _("Sick Leave"),0,0,$Value);
				$rep->Text(420, $past_leave['SL'],0,0,-70);
				$rep->NewLine();
				
				$rep->Text($text_value+10, _("Maternity Leave"),0,0,-70);
				$rep->Text(150, $leaves['ml'],0,0,-70);			
				$rep->Text(330, _("Maternity Leave"),0,0,$Value);
				$rep->Text(420, $past_leave['ML'],0,0,-70);
				$rep->NewLine();			

				$rep->row = 120;
				$rep->Line(205, 0.00001,0,0);

				/* Gross pay*/
				$rep->SetTextColor(255, 152, 0);
				$rep->Text($text_value, _("Gross Pay(Total Earnings)"),0,0,-70);
				$rep->TextCol(1,2, number_format2($myrow['gross'], $dec), -25,-70);
				$rep->SetTextColor(203, 0, 0);
				$rep->Text(330, _("Total Deduction"),0,0,-70);
				$rep->TextCol(3,4,  number_format2($total_deduction, $dec), -5,-70);
				$rep->NewLine(1);
				$rep->SetTextColor(0, 0, 0);		
				
				$rep->Line(165, 0.00001,0,0);	
				$rep->SetTextColor(16, 123, 15);
				$rep->Text($text_value, _("Net Amount ( Total Earnings - Total Deduction)"),0,0,-40);
				$rep->TextCol(3,4,  number_format2($myrow['net_pay'], $dec), -5,-40);			
				$rep->NewLine(1);

				$rep->Line(165, 0.00001,0,0);	
				$rep->SetTextColor(0, 0, 255);
				$rep->NewLine();

				$amount = $myrow['net_pay'];
				if ($amount < 0 || $amount > 999999999999)
					return "";
				$dec = user_price_dec();
				if ($dec > 0)	{
					$divisor = pow(10, $dec);
					$frac = round2($amount - floor($amount), $dec) * $divisor;
					$frac = sprintf("%0{$dec}d", round2($frac, 0));
					$frac = " $frac";
				}
				else
					$frac = "";
				// _number_to_words(intval($amount)) . $frac;
				$rep->Text($text_value, _("Amount in words :"),0,0,-40);
				$rep->TextCol(2,4,  _number_to_words(intval($amount)).' . '._number_to_words($frac), -5,-40);	

				//--------------		
				// $rep->NewLine();
				// $rep->Text($text_value, _("Bank Name(Union Bank of India) :"),0,0,-70);
				// $rep->TextCol(1,2, $kyc['bank_name'], -25,-70);
				// $rep->SetTextColor(0, 0, 255);
				// $rep->Text(330, _("Bank  A/C No :"),0,0,-70);
				// $rep->TextCol(3,4,  $kyc['acc_no'], -5,-70);			
				// $rep->NewLine();
				//--------------

				$rep->Line(135, 0.00001,0,0);
				$rep->Line($line_value-585, 0.00001,0,0);	
				$rep->row = 180;	
				if($comment){	
					$rep->NewLine();			
					$rep->SetTextColor(0, 0, 0);
					$rep->Text($text_value, _("Comments"),0,0,65);
					$rep->Text(200, $comment,0,0,65);  //$rep->NewLine(2);	
				}		
				$rep->Line($line_value-635, 0.00001,0,0);	
		}
		if ($rep->row < $rep->bottomMargin )
			$rep->NewPage();	
		if(isset($_GET['email']) && $_GET['email']== 'yes')
			$rep->End(1, 'Payslip ');
		else
			$rep->End();
	}else{
		display_warning(_("No Payroll Entry Found For Selected Period."));
	}
}
?>