<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/
$page_security = 'HR_PAYSLIP';
$path_to_root="../../..";
include($path_to_root . "/includes/session.inc");
add_access_extensions();
$version_id = get_company_prefs('version_id');

$js = '';
if($version_id['version_id'] == '2.4.1'){
	if ($SysPrefs->use_popup_windows) 
		$js .= get_js_open_window(900, 500);	

	if (user_use_date_picker()) 
		$js .= get_js_date_picker();
	
}else{
	if ($use_popup_windows)
		$js .= get_js_open_window(900, 500);
	if ($use_date_picker)
		$js .= get_js_date_picker();
}
include($path_to_root . "/modules/ExtendedHRM/includes/Payroll.inc" );
include($path_to_root . "/includes/ui.inc");

page(_("Payroll Process"));
$dec = user_price_dec();
check_db_has_employees(sprintf(_("There is no employee in this system. Kindly Open '%s' to update it"), "<a href='".$path_to_root."/modules/ExtendedHRM/manage/employees.php'>"._("Add And Manage Employees")."</a>"));

if (isset($_GET['dept_id'])){
	$_POST['dept_id'] = $_GET['dept_id'];
}
if (isset($_GET['month'])){
	$_POST['month'] = $_GET['month'];
}
if (isset($_GET['year'])){
	$_POST['year'] = $_GET['year'];
}
$dept_id = get_post('dept_id','');
$month = get_post('month','');
$current_year =  get_current_fiscalyear();
$year = get_post('year',$current_year['id']);
 
 if(list_updated('month')) {
		$month = get_post('month');   
		$Ajax->activate('RefreshPayroll');
}

$dim = get_company_pref('use_dimension');
start_form();

if (db_has_employees()) {
	start_table(TABLESTYLE_NOBORDER);
	start_row();	
		kv_fiscalyears_list_cells(_("Fiscal Year").":", 'year', null, true);
		kv_current_fiscal_months_list_cell(_("Months"), "month", null, true,false, 1);		
		end_row();
	start_row();
		kv_empl_grade_list_cells( _("Grade").":", 'grade', null, true, true);
		department_list_cells(_("Select a Department")." :", 'dept_id', null,	_("No Department"), true, check_value('show_inactive'));
		//employee_list_cells(_("Select an Employee"). " :", 'empl_id', null,	_("Select an Employee"), true, check_value('show_inactive'), false, false,true);
	end_row();	
	end_table();

	$hrmsetup = get_hrm_option();	
	//0 - working days Start
	$months_with_years_list = kv_get_months_with_years_in_fiscal_year($year);
 	$ext_year = date("Y", strtotime($months_with_years_list[(int)get_post('month')]));	
	$payroll_monthly_choice =$hrmsetup['monthly_choice'];

 	if($month > 0 && $year > 0 ){
		if($payroll_monthly_choice == 1){
			$to = end_month(sql2date($months_with_years_list[(int)get_post('month')])); 
			$from = begin_month(sql2date($months_with_years_list[(int)get_post('month')])); 
			$total_days =  date("t", strtotime($ext_year."-".$month."-01"));
		} elseif($payroll_monthly_choice == 2){
			$total_days =  ((int)date("t", strtotime($ext_year."-".$month."-01"))-$hrmsetup['BeginDay'])+$hrmsetup['EndDay'];
			$nxt_mnth =  (($month < 12)? ($month+1) : 1);
				
			$from = sql2date(date('Y-m-d', strtotime($ext_year.'-'.$month.'-'.$hrmsetup['BeginDay'])));
			$to = sql2date(date('Y-m-d', strtotime($ext_year.'-'.$nxt_mnth.'-'.$hrmsetup['EndDay'])));
		}elseif($payroll_monthly_choice == 3){
			$pre_mnth = 0 ;
			$pre_mnth =  (($month > 1)? ($month-1) : 12);
			if($pre_mnth == 12 )
				$prev_ext_year = $ext_year-1;
			else
				$prev_ext_year = $ext_year;

			$total_days =  date("t", strtotime($prev_ext_year."-".$pre_mnth."-01"));
				
			$from = sql2date(date('Y-m-d', strtotime($prev_ext_year.'-'.$pre_mnth.'-'.$hrmsetup['BeginDay'])));
			$to = sql2date(date('Y-m-d', strtotime($ext_year.'-'.$month.'-'.$hrmsetup['EndDay'])));				
		}
	}
		//0 - working days End

	if (get_post('_show_inactive_update') || get_post('month') || get_post('year') || list_updated('dept_id')) {
		$Ajax->activate('dept_id');
		$Ajax->activate('month');
		$Ajax->activate('year');
		$Ajax->activate('sal_calculation');
		set_focus('dept_id');
	}
}else{
	hidden('dept_id', get_post('dept_id'));
	hidden('month', get_post('month'));
	hidden('year', get_post('year'));
}

div_start('sal_calculation');

	if(empty($dept_id)) $dept_id = 0;
	$grade = get_post('grade') ; 
	$get_employees_list = get_empl_ids_from_dept_id_payroll($dept_id, $grade);

	start_table(TABLESTYLE_NOBORDER, "width=40%");
	label_row("**"._("Here, you can view the un-Processed Salaries."), '', ' style="text-align:center;" ' ); 
	end_table();
   //$prof_tax = kv_get_Taxable_field();
	start_table(TABLESTYLE, "width=90%");
	$th = array(_("Empl Id"),_("Employee Name"), _("Currrency"), _("Exchange Rate"));
    $All_Allowance = kv_get_allowances(null, 0, $grade);
    $th[] = array(_("Gross Pay"), '#f9f2bb', '#2196F3');
    $th[] = array(_("Absent Deduction") , '#fed', '#f55');
	$th[] = array(_("Gross after LOP"), '#f9f2bb', '#2196F3');
	$basic_id = 0 ;

	$before_ctc_count =0;
	foreach($All_Allowance as $single) {	
		if($single['type'] == 'Earnings'){
			$before_ctc_count +=1;
			$th[] = array(_($single['description']) , '#f9f2bb', '#2196F3');
		}
		if($single['basic'] == 1)
			$basic_id = $single['id'];
	}
	$th[] = array(_("OT"), '#f9f2bb', '#2196F3');
	// $th[] = array(_("Gross Pay"), '#f9f2bb', '#2196F3');

	// $th[] = array(_(" Absent Deduction") , '#fed', '#f55');
	// $th[] = array(_("Gross after LOP"), '#f9f2bb', '#2196F3');

	foreach($All_Allowance as $single) {	
		if($single['type'] == 'Reimbursement'){
			$before_ctc_count +=1;
			$th[] = array(_($single['description']) , '#f9f2bb', '#2196F3');
		}
		if($single['type'] == 'Benefits'){
			$before_ctc_count +=1;
			$th[] = array(_($single['description']) , '#f9f2bb', '#2196F3');
		}
	}
	$th[] = array(_("Total Benefits"), '#f9f2bb', '#2196F3');
	foreach($All_Allowance as $single) {	
		if($single['type'] == 'Employer Contribution'){
			$before_ctc_count +=1;
			$th[] = array(_($single['description']) , 'rgba(156, 39, 176, 0.23)', '#9C27B0');
		}
	}
	$th[] = array(_("Overall CTC"), 'rgba(156, 39, 176, 0.23)', '#9C27B0');
	$after_ctc_count =0;
	foreach($All_Allowance as $single) {	
		if($single['type'] == 'Deductions'){
			$after_ctc_count +=1;
			$th[] = array(_($single['description']) , '#fed', '#f55');
		}
	}
   	$th1 = array(array(_("Adv Salary") , '#fed', '#f55'), /*array(_("LOP Days"), '#fed', '#f55'),*/ /*array(_(" Absent Deduction") , '#fed', '#f55'),*/  array(_("Total Deduction") , '#fed', '#f55'),array(_("Net Salary"), '#B7DBC1' ,  '#107B0F'));
   	$th_final = array_merge($th, $th1);
	// if ($dim >= 1)
	// 	$dimension = _("Dimensions"); 
	// else
	// 	$dimension ="";
	// $th_final[] = $dimension;
	//table_header($th_final);	
	echo '<tr>';	
	foreach($th_final as $header){
		if(is_array($header)){
			echo '<td style="background:'.$header[1].';color:'.$header[2].'"> '.$header[0].'</td>';
		} else {
			echo '<td class="tableheader"> '.$header.'</td>';
		}
	} echo '</tr>';

	$ipt_error = 0;
	//$total_working_hours =  Get_Monthly_WorkingHours($year, get_post('month'), true);	
	if(empty($dept_id)) $dept_id = 1;		
		$months_with_years_list = kv_get_months_with_years_in_fiscal_year($year);
		if($months_with_years_list[(int)get_post('month')] > date('Y-m-d')){
			display_error(_("The Selected Month Yet to Born!"));
			$ipt_error = 1;
		}
		if($ipt_error ==0) {		
			if(list_updated('month') || list_updated('year') || list_updated('grade') || list_updated('dept_id')){
				foreach($get_employees_list as $single_empl){
					unset($_POST[$single_empl['empl_id'].'lop_amount']);
				}
			}
			if(get_post('RefreshPayroll')){	
				foreach($get_employees_list as $single_empl) {
					if(isset($_POST[$single_empl['empl_id'].'lop_amount']))
						$_POST[$single_empl['empl_id'].'lop_amount'] = input_num($single_empl['empl_id'].'lop_amount');
					else
						$_POST[$single_empl['empl_id'].'lop_amount'] = 0;
				}
				$Ajax->activate('RefreshPayrollCalculation');
			}
			$Total_gross = $total_net = 0; 
			$end_of_selected_month = end_month(sql2date($months_with_years_list[(int)get_post('month')])); 
		
		$home_nationality = $hrmsetup['home_nation'];
		$ext_year = date("Y", strtotime($months_with_years_list[(int)get_post('month')]));
		if($hrmsetup['monthly_choice'] == 2){
			$secondMonth = (int)$month+1;
		} elseif($hrmsetup['monthly_choice'] == 3) {				
			$secondMonth = $month;
		} else {
			$secondMonth = $month;
		}
				
		$payroll_process_end = date("Y-m-d", strtotime($ext_year."-".$secondMonth."-".$hrmsetup['EndDay']));		
		div_start('RefreshPayrollCalculation');
		$date_of_pay = Today();
		hidden('date_of_pay', $date_of_pay);
		
		$empl_ids = array();
		foreach($get_employees_list as $single_empl) { 
			$Allowance = kv_get_allowances(null, 0, $single_empl['grade']);
			if($single_empl['status'] == 1 || ($single_empl['status']>1 && $single_empl['date_of_status_change'] >= date2sql($end_of_selected_month ) )){
				
				$Empl_job_row = GetRow('kv_empl_job', array('empl_id' => $single_empl['empl_id']));
				$gross_lop = $Empl_job_row['gross'];
				$Empl_info_row = GetRow('kv_empl_info', array('empl_id' => $single_empl['empl_id']));
				$empl_attendance_ar = array('joining' => $Empl_job_row['joining'], 'status' => $single_empl['status'], 'date_of_status_change' => $single_empl['date_of_status_change']);
				$empl_id = $Empl_job_row['empl_id'];
				$existing_empl_sal = GetRow('kv_empl_salary', array('empl_id' => $empl_id, 'month' => (int)get_post('month'), 'year' => $year));	
				// $sal_row = get_empl_sal_details($empl_id, (int)get_post('month'), $year);				
				$end_of_selected_month = end_month(sql2date($months_with_years_list[(int)get_post('month')]));
				$Empl_info_row =  GetRow('kv_empl_info', array('empl_id' => $empl_id));
				$duration  = GetEmplAttendanceDuration($empl_id,null,null, (int)get_post('month'), $year,-1,-1, ($Empl_info_row['status'] > 1 ? sql2date($Empl_info_row['date_of_status_change']) : null),$Empl_job_row['weekly_off']);

				if(!empty($duration))
					$employee_Lop_hours = $duration[0]['total_hrs'] - ($duration[0]['Duration']+$duration[0]['off_days']);
				else
					$employee_Lop_hours = 0;
						
				$workedHours  = $otHours = $SplotHours = 0 ;
				if(!empty($duration)){
					foreach($duration as $key => $single){
						$workedHours += $single['Duration'];		
						$otHours += $single['OT'];
						$SplotHours += $single['SOT'];
					}
				}

				if($Empl_job_row && empty($existing_empl_sal) && date2sql($end_of_selected_month) >= get_employee_join_date($empl_id)) {						
						// $_POST[$empl_id.'empl_id']= $empl_id; 	
					$_POST[$empl_id.'empl_id']= $empl_id; 	
					$gross_4_LOP = $ctc_cal = $Reimbursement = $basic_id = $gross_calculation = 0 ;
					$_POST['lop_amount'] = 0;
						if(!isset($sal_row['net_pay'])){
							if(!isset($_POST['lop_amount']) || $_POST['lop_amount'] == 0){
								if(isset($duration[0]['total_hrs']) && $duration[0]['total_hrs'] > 0 ){		
										
									if($duration[0]['total_hrs'] == $employee_Lop_hours){
										$_POST[$empl_id.'lop_amount'] = round($Empl_job_row['gross'], 2);							
									}	else {					
										$_POST[$empl_id.'lop_amount'] = round((($Empl_job_row['gross']/$duration[0]['total_hrs'])*abs($employee_Lop_hours)), 2);						
									}
								} else
									$_POST[$empl_id.'lop_amount'] = $Empl_job_row['gross'];							
							}
						}
						$_POST['payable_grosss'] = $Empl_job_row['gross'];
						$_POST['net_gross'] = $Empl_job_row['gross']- $_POST[$empl_id.'lop_amount'];
						// $Empl_job_row['gross'] = $_POST['net_gross'];



						foreach($Allowance as $single) {
							if($single['al_type'] == 0 ){
								$allowance_var_ar[$empl_id.'_'.$single['id']] = '{$'.$single['unique_name'].'}';
					// if(!isset($sal_row['net_pay'])){
						if($single['formula'] == '' && $single['value'] == 'Percentage' && $single['percentage']>0){			
							$_POST[$empl_id.'_'.$single['id']] = input_num($empl_id.'_'.$basic_id)*($single['percentage']/100);
						}elseif($single['value'] == 'Gross Percentage' && $single['percentage']>0){			
							$_POST[$empl_id.'_'.$single['id']] = $_POST['net_gross']*($single['percentage']/100);
						}elseif($single['formula'] != '' && is_numeric($single['formula'])) {
							$_POST[$empl_id.'_'.$single['id']] = $single['formula'];					
						}

					if(!empty($duration) && $duration[0]['Duration'] == 0 && ($single['esic'] == 1 || $single['pf'] == 1))  //ESIC and PF will be 0 for full month absents.
						$_POST[$empl_id.'_'.$single['id']] = 0 ;
					if($single['basic'] == 1) {
						$basic_id = $single['id'];
					}
							}						
						}						
					}
				}
			
				if($single_empl['empl_id'] && empty($existing_empl_sal) && date2sql($end_of_selected_month) >= get_employee_join_date($single_empl['empl_id']) && ($single_empl['status'] == 1 || ($single_empl['status']>1 && $single_empl['date_of_status_change'] >= date2sql($end_of_selected_month) ) )) {
					$empl_ids[] = $single_empl['empl_id'];					
					$pf_amt_actual = 0; 
					$duration  = GetEmplAttendanceDuration($single_empl['empl_id'],null,null, (int)get_post('month'), $year,-1,-1, ($Empl_info_row['status'] > 1 ? sql2date($Empl_info_row['date_of_status_change']) : null), $hrmsetup['weekly_off']);
					if(!empty($duration))
						$employee_Lop_hours = $duration[0]['total_hrs'] - ($duration[0]['Duration']+$duration[0]['off_days']);
					else
						$employee_Lop_hours = 0;
					$workedHours  = $otHours = $SplotHours = 0 ;
					if(!empty($duration)){
						foreach($duration as $key => $single){
							$workedHours += $single['Duration'];
							$otHours += $single['OT'];
							$SplotHours += $single['SOT'];
						}
					}	
	
					//$employee_working_hours=Get_Monthly_EmployeeWorkingHours($single_empl['empl_id'], $year, get_post('month'), true, $empl_attendance_ar);
					//$employee_Lop_hours = $total_working_hours[0] - $employee_working_hours[0];
					$ot_mul_factor = get_hrm_option('ot_factor');	
					$gross_4_LOP = $ctc_cal = $Reimbursement = $basic_id = $gross_calculation = 0 ;
					$end_of_selected_month = end_month(sql2date($months_with_years_list[(int)get_post('month')])); 
					$begin_this_month = begin_month(sql2date($months_with_years_list[(int)get_post('month')])); 
					foreach($Allowance as $single) {
						if($single['al_type'] == 0 ){
							$_POST[$single_empl['empl_id'].$single['id']] = (isset($_POST[$single_empl['empl_id'].$single['id']]) ? $_POST[$single_empl['empl_id'].$single['id']] : 0 );

							if($single['type']=='Earnings'){
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 );
							}
							if($single['type']=='Reimbursement'){
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 );
							}
							if($single['type']=='Deductions'){
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 );
							}
							if($single['type']=='Employer Contribution'){ 							
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 );
							}	
						} elseif($single['al_type']==1){  // LMRA Calculation			
							$amount =GetRow('kv_empl_lmra_fees',  array('nationality' => $Empl_job_row['nationality'])); 
							if(!empty($amount))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = $amount['amount'];
							elseif($amount2 =  GetSingleValue('kv_empl_lmra_fees', 'amount', array('nationality' => 0)))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = $amount2;
							else
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0 ;
						}elseif($single['al_type']==3){  // Medical Allowance
							$medi_category= GetSingleValue('kv_empl_medical_premium', 'month', array('id' => $Empl_job_row['medi_category'])); 
							if($medi_category)
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = $medi_category;
							else
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = null;
						} elseif($single['al_type']==4){	// Visa and immgration
							$visa_details= GetRow('kv_empl_visa_exp', array('nationality' => $Empl_job_row['nationality'], 'family' => $Empl_job_row['family']));							
							if ($visa_details){  
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = $visa_details['month'];
							}else {
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = GetSingleValue('kv_empl_visa_exp', 'month', array('nationality' => 0, 'family' => $Empl_job_row['family']));
							}
						} elseif($single['al_type']==5){ //Leave Travel
							$leave_travel= GetRow('kv_empl_leave_travel', array('nationality' => $Empl_job_row['nationality'], 'family' => $Empl_job_row['family']));
							if ($leave_travel){  
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = $leave_travel['month'];
							}else {
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = GetSingleValue('kv_empl_leave_travel', 'month', array('nationality' => 0, 'family' => $Empl_job_row['family']));
							}
						} elseif($single['al_type']==6){   // Leave Salary 
							$ALDays = ($Empl_job_row['al']/12);
							
							$amt_for_cal = 0 ;
								foreach($Allowance as $singl) {									
									if( !empty($hrmsetup['leave_pay']) && in_array($singl['id'], $hrmsetup['leave_pay']))
										$amt_for_cal += $_POST[$single_empl['empl_id'].'_'.$singl['id']] ;
								}								
								if($amt_for_cal==0)
									$amt_for_cal = $gross_4_LOP;								
								
							$_POST[$single_empl['empl_id'].'_'.$single['id']] =((($amt_for_cal*12)/365)*$ALDays);
							if(date2sql($begin_this_month) < $Empl_job_row['joining']){
								$days = 30 - (int)date('d', strtotime($Empl_job_row['joining']));								
								$ALDays = ($ALDays/30)*$days;
								$_POST[$single_empl['empl_id'].'_'.$single['id']] =((($amt_for_cal*12)/365)*($ALDays));
							} 
							if(!isset($sal_row['net_pay']) && $Empl_info_row['status']>1 && $Empl_info_row['date_of_status_change'] > date2sql($begin_this_month) && $Empl_info_row['date_of_status_change'] < date2sql($end_of_selected_month) ) {
								$days = (int)date('d', strtotime($Empl_info_row['date_of_status_change']));								
								$ALDays = ($ALDays/30)*$days;
								$_POST[$single_empl['empl_id'].'_'.$single['id']] =((($amt_for_cal*12)/365)*($ALDays));
							}
						} elseif($single['al_type']==7){   // Indemnity
							if($home_nationality  != $Empl_job_row['nationality']){
								$date1 = new DateTime($Empl_job_row['joining']);
								$date2 = new DateTime(date('Y-m-d'));
								$interval = $date1->diff($date2);
								$years_exp = $interval->y + ($interval->m/12) + ($interval->d/365);							
								$cal_days = (($years_exp > 3) ? 30 : 15 );
								$amt_for_cal = 0 ;
								foreach($Allowance as $singl) {									
									if( !empty($hrmsetup['indemnity']) && in_array($singl['id'], $hrmsetup['indemnity']))
										$amt_for_cal += $_POST[$single_empl['empl_id'].'_'.$singl['id']] ;
								}								
								if($amt_for_cal==0)
									$amt_for_cal = $gross_4_LOP;
								$_POST[$single_empl['empl_id'].'_'.$single['id']] =((($amt_for_cal*12)/365)*$cal_days)/12;								
							} else {
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
							}
						} elseif($single['al_type'] == 2) { //GOSI Calculation	
							if((!isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) || $_POST[$single_empl['empl_id'].'_'.$single['id']] == '' || get_post($single_empl['empl_id'].'_'.$single['id']) == 0)){ 							
								$gosi_emplee= GetRow('kv_empl_gosi_settings', array('nationality' => $Empl_job_row['nationality']));
								if(empty($gosi_emplee))
									$gosi_emplee =  GetRow('kv_empl_gosi_settings', array('nationality' => 0));
								$gosi_cal_amt = 0 ;
								$gosi_al = unserialize(base64_decode($gosi_emplee['allowances']));
								if(!empty($gosi_al)){									
									foreach($gosi_al as $singl){
										$gosi_cal_amt += input_num($single_empl['empl_id'].'_'.$singl);
									}
								} 
								if($gosi_cal_amt == 0 )
									$gosi_cal_amt = $gross_4_LOP; 
								
								if($single['type']=='Deductions' ){									
									if ($gosi_emplee){  							
										$_POST[$single_empl['empl_id'].'_'.$single['id']] = $gosi_cal_amt * ($gosi_emplee['employee']/100);
									}else {  	
										$_POST[$single_empl['empl_id'].'_'.$single['id']] = $gosi_cal_amt * ($gosi_emplee['employee']/100);
									}
								}	elseif( $single['type']=='Employer Contribution' ){									
									if ($gosi_emplee){  							
										$_POST[$single_empl['empl_id'].'_'.$single['id']] = $gosi_cal_amt * ($gosi_emplee['employer']/100);
									} else {  
										$_POST[$single_empl['empl_id'].'_'.$single['id']] = $gosi_cal_amt * ($gosi_emplee['employer']/100);
									}
								}
							} 
							
						} 

						if($single['type'] == 'Earnings' && $single['value'] != 'Payroll Input'){
					$gross_4_LOP += input_num($single_empl['empl_id'].'_'.$single['id']);
					
				}
				if($single['type']=='Earnings')
						$gross_calculation  += input_num($single_empl['empl_id'].'_'.$single['id']);
				if($single['type'] == 'Reimbursement') { 
					$Reimbursement += input_num($single_empl['empl_id'].'_'.$single['id']);
				}
				if( $single['type'] == 'Employer Contribution' ){  
					$ctc_cal += input_num($single_empl['empl_id'].'_'.$single['id']);
				}	
				if($single['basic'] == 1)	
						$basic_allowance = input_num($single_empl['empl_id'].'_'.$single['id']);


			$allowance_var_ar = array();
			foreach($Allowance as $single) {				
				if($single['al_type'] == 0 ){
					$allowance_var_ar[$single_empl['empl_id'].'_'.$single['id']] = '{$'.$single['unique_name'].'}';
					if(!isset($sal_row['net_pay'])){
						if($single['formula'] == '' && $single['value'] == 'Percentage' && $single['percentage']>0){			
							$_POST[$single_empl['empl_id'].'_'.$single['id']] = input_num($single_empl['empl_id'].'_'.$basic_id)*($single['percentage']/100);
						}elseif($single['value'] == 'Gross Percentage' && $single['percentage']>0){			
							$_POST[$single_empl['empl_id'].'_'.$single['id']] = $_POST['net_gross']*($single['percentage']/100);
						}elseif($single['formula'] != '' && is_numeric($single['formula'])) {
							$_POST[$single_empl['empl_id'].'_'.$single['id']] = $single['formula'];					
						}
					} else {

						if($single['type']=='Earnings'){
							
							if( (isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0))	
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = ((isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0 ) ? $sal_row[$single['id']] : (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 ));				
						}
						if($single['type']=='Reimbursement'){
							$allowance_var_ar[$single_empl['empl_id'].'_'.$single['id']] = '{$'.$single['unique_name'].'}';
							if((isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0))	
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = ((isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0 ) ? $sal_row[$single['id']] : (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 ));
						}
						if($single['type']=='Deductions'){
							$allowance_var_ar[$single_empl['empl_id'].'_'.$single['id']] = '{$'.$single['unique_name'].'}';
							if((isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0))	
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = ((isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0 ) ? $sal_row[$single['id']] : (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 ));
						}
						if($single['type']=='Employer Contribution'){ 
							$allowance_var_ar[$single_empl['empl_id'].'_'.$single['id']] = '{$'.$single['unique_name'].'}';
							if( (isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0))	
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = ((isset($sal_row[$single['id']]) && $sal_row[$single['id']] > 0 ) ? $sal_row[$single['id']] : (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 0 ));
						}	
					}					
					if(!empty($duration) && $duration[0]['Duration'] == 0 && ($single['esic'] == 1 || $single['pf'] == 1))  //ESIC and PF will be 0 for full month absents.
						$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0 ;
					if($single['basic'] == 1) {
						$basic_id = $single['id'];
					}									
					if(isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) && $single['pf'] == 1){
						if($single['type'] == 'Earnings')
							$pf_amt_actual = $_POST[$single_empl['empl_id'].'_'.$single['id']];
						if($single['type'] == 'Reimbursement')
							$pf_amt_actual = $_POST[$single_empl['empl_id'].'_'.$single['id']];
						if($single['type'] == 'Employer Contribution')
							$pf_amt_actual = $_POST[$single_empl['empl_id'].'_'.$single['id']];
						if($single['type'] == 'Deductions')
							$pf_amt_actual = $_POST[$single_empl['empl_id'].'_'.$single['id']];
					}				
				}	
			}
			if($single['type'] == 'Earnings' && $single['value'] != 'Payroll Input'){
					$gross_4_LOP += input_num($single_empl['empl_id'].'_'.$single['id']);
					
				}
				if($single['type']=='Earnings')
						$gross_calculation  += input_num($single_empl['empl_id'].'_'.$single['id']);
				if($single['type'] == 'Reimbursement') { 
					$Reimbursement += input_num($single_empl['empl_id'].'_'.$single['id']);
				}
				if( $single['type'] == 'Employer Contribution' ){  
					$ctc_cal += input_num($single_empl['empl_id'].'_'.$single['id']);
				}	
				if($single['basic'] == 1)	
						$basic_allowance = input_num($single_empl['empl_id'].'_'.$single['id']);
			
			foreach($Allowance as $single) {
				$yes = false;
				if($single['type'] == 'Earnings'  && isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) && $_POST[$single_empl['empl_id'].'_'.$single['id']] < 1)
					$yes =true; 
				if($single['type'] == 'Deductions'  && isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) && $_POST[$single_empl['empl_id'].'_'.$single['id']] < 1)
					$yes =true; 
				if($single['type'] == 'Reimbursement'  && isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) && $_POST[$single_empl['empl_id'].'_'.$single['id']] < 1)
					$yes =true; 
				if($single['type'] == 'Employer Contribution'  && isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) && $_POST[$single_empl['empl_id'].'_'.$single['id']] < 1)
					$yes =true; 

				if($single['value'] == 'Formula' && $single['formula'] != '' && !isset($sal_row['net_pay']) && !is_numeric($single['formula']) && $yes && (strpos($single['formula'], '{$ctc}') === false)){

					foreach($allowance_var_ar as $key => $allown){
						if(isset($allown,$_POST[$key]))
						$single['formula'] = str_replace($allown,$_POST[$key],strtolower($single['formula']));
					}

					if (strpos($single['formula'], '{$gros}') !== false) {					 	
					 	$single['formula'] = str_replace('{$gros}', $_POST['net_gross'] ,strtolower($single['formula']));
					}if (strpos($single['formula'], '{$grlp}') !== false) {					 	
					 	$single['formula'] = str_replace('{$grlp}', $_POST['net_gross'] ,strtolower($single['formula']));
					}
					if (strpos($single['formula'], '{$ctc}') !== false) {					 	
					 	$single['formula'] = str_replace('{$ctc}', $ctc_final ,strtolower($single['formula']));
					}

					if($single['type'] == 'Earnings')							
						$_POST[$single_empl['empl_id'].'_'.$single['id']] = round(calculate_string($single['formula']),2);	

					if($single['type'] == 'Employer Contribution')							
						$_POST[$single_empl['empl_id'].'_'.$single['id']] = round(calculate_string($single['formula']),2);	

					if($single['type'] == 'Reimbursement')							
						$_POST[$single_empl['empl_id'].'_'.$single['id']] = round(calculate_string($single['formula']),2);

					if($single['type'] == 'Deductions')						
						$_POST[$single_empl['empl_id'].'_'.$single['id']] = round(calculate_string($single['formula']),2);	
							
				}

				if($single['basic'] == 1)
					$basic_allowance = input_num($single_empl['empl_id'].'_'.$single['id']);


				if($single['loan'] == 1 ) {
							$loans = GetDataJoinRow('kv_empl_loan_types AS type', array( 
									0 => array('join' => 'INNER', 'table_name' => 'kv_empl_loan AS loan', 'conditions' => '`type`.`id` = `loan`.`loan_type_id`'),
									1 => array('join' => 'INNER', 'table_name' => 'kv_empl_allowances AS info', 'conditions' => '`type`.`allowance_id` = `info`.`id`'), 
									//2 => array('join' => 'INNER', 'table_name' => 'kv_empl_job AS job', 'conditions' => '`job`.`empl_id` = `loan`.`empl_id`') 
								), 
							array('`loan`.`monthly_pay`, `loan`.`start_date`, `loan`.`periods_paid` , `loan`.`periods`, `loan`.`id`'), array('`loan`.`empl_id`' => $single_empl['empl_id'], '`info`.`id`' => $single['id'], '`loan`.`status`' => 0));
								
							if(!empty($loans) && $loans['periods_paid'] < $loans['periods'] && strtotime(date('Y-m-01', strtotime($loans['start_date']))) <= strtotime($months_with_years_list[(int)get_post('month')])

						/*strtotime($loans['date']) <= strtotime($months_with_years_list[(int)get_post('month')]) */){
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = (isset($_POST[$single_empl['empl_id'].'_'.$single['id']]) ? $_POST[$single_empl['empl_id'].'_'.$single['id']] : 1); //$loans['monthly_pay'];	
								$_POST['loan_'.$single_empl['empl_id'].'_'.$single['id']] = $loans['id'];
								$_POST['loan_mnth_pay_'.$single_empl['empl_id'].'_'.$single['id']] = $loans['monthly_pay'];		
								hidden('loan_'.$single_empl['empl_id'].'_'.$single['id'], $_POST['loan_'.$single_empl['empl_id'].'_'.$single['id']]);
								hidden('loan_mnth_pay_'.$single_empl['empl_id'].'_'.$single['id'], $_POST['loan_mnth_pay_'.$single_empl['empl_id'].'_'.$single['id']]);
							}						
						}

			}



			if(($Empl_job_row['empl_type'] != 1 && $Empl_job_row['empl_type'] != 3 ) && ($single['esic'] == 1 || $single['pf'] == 1 || $single['Tax'] == 1 )){
					$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
				}

//-----------------------------------------------//			
				if($single['type'] == 'Earnings' && $single['value'] != 'Payroll Input'){
					$gross_4_LOP += input_num($single_empl['empl_id'].'_'.$single['id']);
					
				}
				if($single['type']=='Earnings')
						$gross_calculation  += input_num($single_empl['empl_id'].'_'.$single['id']);
				if($single['type'] == 'Reimbursement') { 
					$Reimbursement += input_num($single_empl['empl_id'].'_'.$single['id']);
				}
				if( $single['type'] == 'Employer Contribution' ){  
					$ctc_cal += input_num($single_empl['empl_id'].'_'.$single['id']);
				}	
				// if($single['basic'] == 1)	
				// 		$basic_allowance = input_num($single_empl['empl_id'].'_'.$single['id']);					
						
						// if($single['type'] == 'Earnings' && $single['value'] != 'Payroll Input'){
						// 	$gross_4_LOP += input_num($single_empl['empl_id'].'_'.$single['id']);
						// }
						// if($single['type'] == 'Reimbursement') { 
						// 	$Reimbursement += input_num($single_empl['empl_id'].'_'.$single['id']);
						// }
						// if( $single['type'] == 'Employer Contribution' ){  
						// 	$ctc_cal += input_num($single_empl['empl_id'].'_'.$single['id']);
						// }	
						
						if($single['Tax'] == 1 )	
							$Tax_id = $single_empl['empl_id'].'_'.$single['id'];
						// if($single['basic'] == 1)	
						// 	$basic_allowance = input_num($single_empl['empl_id'].'_'.$single['id']);
					}			 
					
					$gross_emp_amt = $Empl_job_row['gross'];
					if($gross_4_LOP > 0 )
						$gross_amt = $gross_4_LOP;
					else
						$gross_amt = $gross_emp_amt; 
							
					$ctc_final = $ctc_cal + $gross_amt+ $Reimbursement;		
					/*$advance_salary = GetSingleValue('kv_empl_salary_advance', 'amount', array('empl_id' => $single_empl['empl_id'], /*'month' => get_post('month'), *//* 'year' => get_post('year')));
					if(is_array($advance_salary)) {
						foreach($advance_salary as $ad_v_sal){
							if(date2sql($duration[0]['from']) < $ad_v_sal['date'] && $ad_v_sal['date'] < date2sql($duration[0]['to']))
								$_POST[$single_empl['empl_id'].'adv_sal']= $ad_v_sal['amount'];
						}
					}	*/
					$basic_amount = ($basic_id ? $Empl_job_row[$basic_id] : 0);
					/*$ot_mul_factor =get_hrm_option('ot_factor');
					$OT_whours = floor($employee_working_hours[1] / 3600);
					$OT_wmins = floor($employee_working_hours[1] / 60 % 60);
					$OT_Fraction = $OT_whours+ round($OT_wmins / 60, 2);
					$ot_earnings = round(($ot_mul_factor * ($basic_amount/208))*$OT_Fraction);
					*/
		// if(!isset($existing_empl_sal['net_pay'])){
			if($duration == true){
				hidden('from_a_date',$duration[0]['from']);
				hidden('to_a_date',$duration[0]['to']);
				hidden('used_al',$duration[0]['al']);
				hidden('days',$duration[0]['days_count']);
			}else{
				if(isset($from)){
					hidden('from_a_date',$from);
					hidden('to_a_date',$to);
				}
				hidden('used_al',0);
				hidden('days',0);
			}
		// }
		hidden('workedHours', $workedHours);
		hidden('otHours', $otHours);
		hidden('SplotHours', $SplotHours);		
		$hours = floor($workedHours / 3600);
		$mins = floor($workedHours / 60 % 60);
		$employee_working_hours_display = ($hours < 10 ? '0'.$hours : $hours).':'.($mins < 10 ? '0'.$mins : $mins); 
		$ot_hours = floor($otHours / 3600);
		$ot_mins = floor($otHours / 60 % 60);
		$employee_OT_hours_display = ($ot_hours < 10 ? '0'.$ot_hours : $ot_hours).':'.($ot_mins < 10 ? '0'.$ot_mins : $ot_mins);

		$sot_hours = floor($SplotHours / 3600);
		$sot_mins = floor($SplotHours / 60 % 60);
		$employee_sOT_hours_display = ($sot_hours < 10 ? '0'.$sot_hours : $sot_hours).':'.($sot_mins < 10 ? '0'.$sot_mins : $sot_mins);


					$ot_mul_factor =$hrmsetup['ot_factor'];
					if(!empty($duration) && $duration[0]['days_count'] > 0 )
						$days_count = $duration[0]['days_count'];
					else					
						$days_count = 30; 
					$shift_time = GetRow('kv_empl_shifts', array('id' => $Empl_job_row['shift']));
					if(!empty($shift_time)){
						$BeginTime = $shift_time['BeginTime'];
						$EndTime = $shift_time['EndTime'];
					} else {
						$BeginTime = $hrmsetup['BeginTime'];
						$EndTime = $hrmsetup['EndTime'];
					}
					if(isset($basic_allowance)){	//SplitHours
						$ot_earnings = round((((int)$hrmsetup['ot_factor']) * (($basic_allowance/$days_count)/(strtotime($EndTime)-strtotime($BeginTime)))*$otHours),2);
						$ot_earnings += round((((int)$hrmsetup['special_ot_factor']) * (($basic_allowance/$days_count)/(strtotime($EndTime)-strtotime($BeginTime)))*$SplotHours),2);
					} else 
						$ot_earnings = 0;
					$_POST[$single_empl['empl_id'].'_'.'ot_earnings'] = round($ot_earnings);					
					$gross_4_grand = 0 ;
					foreach($Allowance as $single) {	
						if($single['type'] == 'Earnings' ){
							$gross_4_grand += input_num($single_empl['empl_id'].'_'.$single['id']);			
						}								
					}			
					$_POST[$single_empl['empl_id'].'ear_tot'] = $ot_earnings+round($gross_4_grand,3);	

					$_POST['net_gross'] += round($ot_earnings);			
					// if( isset($Tax_id)){			
					// 	if(isset($_POST[$Tax_id]))
					// 		$_POST[$Tax_id] = input_num($Tax_id);
					// 	else
					// 		$_POST[$Tax_id] = kv_get_tax_for_an_employee($single['id'], $single_empl['empl_id'], $year, $Empl_job_row['gross'], get_post('month'));		
					// }
					if($single['Tax'] == 1 )
						$_POST[$Tax_id] = kv_get_tax_for_an_employee($single['id'], $single_empl['empl_id'], $year, $Empl_job_row['gross'], get_post('month'));

					if(isset($Empl_job_row['currency']) && $Empl_job_row['currency'] != ''){
						$curr_code =  $Empl_job_row['currency'];
						$ex_dat =  Today();
						$ex_rate = number_format(get_exchange_rate_from_home_currency($curr_code, $ex_dat), 4);
					} else{
						$curr_code = get_company_currency();
						$ex_rate = 1; 
					}

					hidden($empl_id.'currency', $curr_code);
					hidden($empl_id.'rate', $ex_rate);
					start_row();			
					label_cell($single_empl['empl_id']);
					label_cell(kv_get_empl_name($single_empl['empl_id']));
					label_cell(GetSingleValue('currencies', 'currency', array('curr_abrev' => $curr_code)));
					label_cell( number_format2($ex_rate, 4));

					label_cell( price_format($_POST['payable_grosss']), ' style=" text-align:right;" ' );
					hidden($single_empl['empl_id'].'gross_salary', $_POST[$single_empl['empl_id'].'ear_tot'] );

					amount_cells(null, $single_empl['empl_id'].'lop_amount', $_POST['lop_amount']);	

					// $_POST['net_gross'] = ($_POST[$single_empl['empl_id'].'ear_tot']) - input_num($single_empl['empl_id'].'lop_amount');
					label_cell( price_format($_POST['net_gross']), ' style=" text-align:right;" ' );
					for($vj = 0; $vj<count($All_Allowance);$vj++){
						if(isset($Allowance[$vj]['id']) && $All_Allowance[$vj]['id'] == $Allowance[$vj]['id']){
							//$All_Allowance[$vj] = $All_Allowance[$vj];
							$All_Allowance[$vj]['value'] = $Allowance[$vj]['value'];
						}
					}
					foreach($All_Allowance as $single) {							
						if($single['type'] == 'Earnings' ){
							if(!isset($_POST[$single_empl['empl_id'].'_'.$single['id']]))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
							if($single['value'] == 'Payroll Input' && $single['basic'] != 1){	
								amount_cells_ex(null, $single_empl['empl_id'].'_'.$single['id'], null, 15);
							}else{
								label_cell(($_POST[$single_empl['empl_id'].'_'.$single['id']] != ($_POST[$single_empl['empl_id'].'_'.$single['id']] >-$_POST[$single_empl['empl_id'].'_'.$single['id']])) ? '0' :price_format($_POST[$single_empl['empl_id'].'_'.$single['id']]), ' style=" text-align:right;" ');								
							}
							hidden($single_empl['empl_id'].$single['id'], $_POST[$single_empl['empl_id'].'_'.$single['id']]);
						} 
					}  					
					
					label_cell(price_format($_POST[$single_empl['empl_id'].'_'.'ot_earnings']),' style=" text-align:right;" ');
					hidden($single_empl['empl_id'].'ot_earnings', $_POST[$single_empl['empl_id'].'_'.'ot_earnings'] );

					$reimburse = 0; 
					foreach($All_Allowance as $single) {							
						if($single['type'] == 'Reimbursement'){
							if(!isset($_POST[$single_empl['empl_id'].'_'.$single['id']]))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
							if( $single['value'] == 'Payroll Input')
								amount_cells_ex(null, $single_empl['empl_id'].'_'.$single['id'], null, 15);
							else{
								label_cell(price_format($_POST[$single_empl['empl_id'].'_'.$single['id']]), ' style=" text-align:right;" ');								
							}	
							hidden($single_empl['empl_id'].$single['id'], $_POST[$single_empl['empl_id'].'_'.$single['id']]);	
							$reimburse += input_num($single_empl['empl_id'].'_'.$single['id']);							
						}

						if($single['type'] == 'Benefits'){
							if(!isset($_POST[$single_empl['empl_id'].'_'.$single['id']]))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
							if(!isset($sal_row['net_pay']) && $single['value'] == 'Payroll Input')
								amount_cells_ex(null, $single_empl['empl_id'].'_'.$single['id'], null, 15);
							else{
								label_cell(price_format($_POST[$single_empl['empl_id'].'_'.$single['id']]), ' style=" text-align:right;" ');								
							}	
							hidden($single_empl['empl_id'].$single['id'], $_POST[$single_empl['empl_id'].'_'.$single['id']]);	
							$reimburse += input_num($single_empl['empl_id'].'_'.$single['id']);							
						}
					}	

					$_POST[$single_empl['empl_id'].'payable_gross'] = /*$reimburse + */$_POST[$single_empl['empl_id'].'ear_tot'];
					label_cell( price_format($reimburse), ' style=" text-align:right;" ' );
					hidden($single_empl['empl_id'].'benefits', $_POST[$single_empl['empl_id'].'payable_gross'] );
				
					$ctc_grand = get_post($single_empl['empl_id'].'payable_gross')+$reimburse;
					
					foreach ($All_Allowance as $single) {						
						if( $single['type'] == 'Employer Contribution' ){  
							if(!isset($_POST[$single_empl['empl_id'].'_'.$single['id']]))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
							//if($single['esic'] != 1 && $single['pf'] != 1){
								if($single['value'] == 'Payroll Input')
									amount_cells_ex(null, $single_empl['empl_id'].'_'.$single['id'], null, 10, 10);
								else
									label_cell( price_format($_POST[$single_empl['empl_id'].'_'.$single['id']]), '', ' style=" text-align:right;" ');
								$ctc_grand += input_num($single_empl['empl_id'].'_'.$single['id']);
							hidden($single_empl['empl_id'].$single['id'], $_POST[$single_empl['empl_id'].'_'.$single['id']]);					
						}
					}						
					label_cell( price_format($ctc_grand), ' style=" text-align:right;" ' );
					hidden($single_empl['empl_id'].'ctc', $ctc_grand );					
					$deduct_tot = 0 ;		
					foreach($All_Allowance as $single) {
						if($single['type'] == 'Deductions'){
							if(!isset($_POST[$single_empl['empl_id'].'_'.$single['id']]))
								$_POST[$single_empl['empl_id'].'_'.$single['id']] = 0;
							//if($single['esic'] != 1 && $single['pf'] != 1 ){
								if($single['value'] == 'Payroll Input' && $single['loan'] != 1){
									amount_cells_ex(null, $single_empl['empl_id'].'_'.$single['id'], null, 10, 10);
									$deduct_tot += $_POST[$single_empl['empl_id'].'_'.$single['id']];
								}elseif( $single['loan'] != 1){
									amount_cell($_POST[$single_empl['empl_id'].'_'.$single['id']], $dec);
									$deduct_tot += $_POST[$single_empl['empl_id'].'_'.$single['id']];
								}else {
									kv_loan_balance_dropdown_cells(null, $single_empl['empl_id'].'_'.$single['id'], input_num('loan_'.$single_empl['empl_id'].'_'.$single['id']), false, true);
									if(isset($_POST['loan_mnth_pay_'.$single_empl['empl_id'].'_'.$single['id']]))
										$deduct_tot += $_POST[$single_empl['empl_id'].'_'.$single['id']]*$_POST['loan_mnth_pay_'.$single_empl['empl_id'].'_'.$single['id']];
									$periods_cot = $_POST[$single_empl['empl_id'].'_'.$single['id']];
									if(list_updated($single_empl['empl_id'].'_'.$single['id']))
										$Ajax->activate('sal_calculation');
								}
							hidden($single_empl['empl_id'].$single['id'], $_POST[$single_empl['empl_id'].'_'.$single['id']]);
						}
					}
					//$_POST[$single_empl['empl_id'].'adv_sal']= GetSingleValue('kv_empl_salary_advance', 'amount', array('empl_id' => $single_empl['empl_id'], 'month' => get_post('month'), 'year' => get_post('year')));
					$_POST[$single_empl['empl_id'].'adv_sal'] = 0 ;
					$advance_salary = GetAll('kv_empl_salary_advance', array('empl_id' => $single_empl['empl_id']));
					if(is_array($advance_salary)) {
						foreach($advance_salary as $ad_v_sal){
							if(isset($duration[0])){								
								if(date2sql($duration[0]['from']) < $ad_v_sal['date'] && $ad_v_sal['date'] < date2sql($duration[0]['to'])){									
									$_POST[$single_empl['empl_id'].'adv_sal']= $ad_v_sal['amount'];
									$_POST[$single_empl['empl_id'].'adv_date']= $ad_v_sal['date'];
								}
							}
						}
					}

					if(isset($_POST[$single_empl['empl_id'].'adv_sal'])){
						label_cell(price_format($_POST[$single_empl['empl_id'].'adv_sal']), ' style=" text-align:right;" ');
						hidden($single_empl['empl_id'].'adv_sal', $_POST[$single_empl['empl_id'].'adv_sal'] ); 	
						if(isset($_POST[$single_empl['empl_id'].'adv_date']))
							hidden($single_empl['empl_id'].'adv_date', $_POST[$single_empl['empl_id'].'adv_date'] ); 	
						$deduct_tot += $_POST[$single_empl['empl_id'].'adv_sal'];
					} else 
						amount_cell('');
					// $deduct_tot += input_num( $_POST[$single_empl['empl_id'].'adv_sal']);
					label_cell(price_format($deduct_tot), ' style=" text-align:right;" ' );
					hidden($single_empl['empl_id'].'net_deductions', $deduct_tot ); 
					$net_pay = $_POST['net_gross'] - $deduct_tot+$reimburse; 
					label_cell(price_format($net_pay), ' style=" text-align:right;" ');
					hidden($single_empl['empl_id'].'net_pay', $net_pay ); 
					$Total_gross += $_POST[$single_empl['empl_id'].'payable_gross'];
					$total_net += $net_pay;
					// if ($dim >= 1){
					// 	dimensions_list_cells(null, $single_empl['empl_id'].'dimension_id', null, true, " ", false, 1);
					// 	if ($dim > 1)
					// 		dimensions_list_cells(null, $single_empl['empl_id'].'dimension2_id', null, true, " ", false, 2);
					// }
					// if ($dim < 1)
					// 	hidden($single_empl['empl_id'].'dimension_id', 0);
					// if ($dim < 2)
					// 	hidden($single_empl['empl_id'].'dimension2_id', 0);
					if(!empty($duration))
						hidden($single_empl['empl_id'].'allowed_al',$duration[0]['al']);
					if($duration == true){
						hidden('from_a_date',$duration[0]['from']);
						hidden('to_a_date',$duration[0]['to']);
					}else{
						if(isset($from)){
							hidden('from_a_date',$from);
							hidden('to_a_date',$to);
						}
					}
					end_row();
				}
			}			
			hidden('empl_ids', implode("-", $empl_ids));
			div_end();			
			start_row();
			$before_ctc_count +=7;		
			$after_ctc_count;
			
			echo "<td colspan='".$before_ctc_count."'> </td> <td colspan='2' align='center'><strong>"._("Total Gross")."</strong></td><td align='right'><strong>".price_format($Total_gross)."</strong></td> ";
			if($after_ctc_count >0){
				echo "<td colspan='".$after_ctc_count."'> ";
			}
			echo "</td><td colspan='2' align='center'><strong>"._("Total Net Salary")."</strong></td> <td align='right'><strong>". price_format($total_net)."</strong></td><td colspan='5'> </td>  ";
			end_row();
			  submit_cells('RefreshPayroll', _("Refresh"),'',_("Show Results"), true);
		}
    end_table(1);
  

	if(isset($payroll_process_end) && ($payroll_process_end < date('Y-m-d')))
		submit_center('pay_salary', _("Process Payout"), true, _("Payout to Employees"), 'default');
	else
		display_warning(_("You can't Process Payroll of future!"));

	div_end(); 
	end_form(); 

	if(get_post('pay_salary')) {
	$Ajax->activate('sal_calculation');			
	$get_employees_list = explode("-", $_POST['empl_ids']);			

	$Allowance = kv_get_allowances(null, 0, get_post('grade'));
	begin_transaction();
	foreach($get_employees_list as $empl_id) {  

		$jobs_arr =  array('empl_id' => $empl_id,
							 'month' => $_POST['month'],
							 'days_worked' => $_POST['days'],
							 'from_date' => date2sql($_POST['from_a_date']),
							 'to_date' => date2sql($_POST['to_a_date']),
							 'year' => $_POST['year'],
							 'currency' => $_POST[$empl_id.'currency'],
							 'rate' => input_num($empl_id.'rate'),
							 'gross' => input_num($empl_id.'gross_salary'),	
							 'pay_hrs' => input_num('workedHours'),
							 'ot_hrs' => input_num('otHours'),
							 'spl_ot_hrs' => input_num('SplotHours'),			 
							 'al' => $_POST['used_al'],				
							 'ctc' => input_num($empl_id.'ctc'),	
							 //'ML' => $_POST[$empl_id.'allowed_ml'],							 
							// 'CL' => $_POST[$empl_id.'allowed_cl'],							 
							 // 'AL' => $_POST[$empl_id.'allowed_al'],	
							 'dimension' => 0,
							 'dimension2' => 0, 
							 'date' => array(Today(), 'date'), 
							 'adv_sal' => input_num($empl_id.'adv_sal'),
							 'net_pay' => input_num($empl_id.'net_pay'), 
							 'ot_earnings'=>input_num($empl_id.'ot_earnings'),
						 	 'lop_amount' => input_num($empl_id.'lop_amount'));
		$loan_id = array();
		$loan_id_amount = 0;
		$myloan = GetAll('kv_empl_loan', array('empl_id' => $empl_id));
		foreach($Allowance as $single) {	
			
			if($single['loan'] == 1 && isset($_POST['loan_'.$empl_id.'_'.$single['id']])){
				$loan_id[] = array(input_num('loan_'.$empl_id.'_'.$single['id']), $_POST['loan_mnth_pay_'.$empl_id.'_'.$single['id']], input_num($empl_id.'_'.$single['id']));  
				$jobs_arr[$single['id']] = input_num($empl_id.'_'.$single['id'])*$_POST['loan_mnth_pay_'.$empl_id.'_'.$single['id']];
				$loan_id_amount += input_num($empl_id.'_'.$single['id'])*$_POST['loan_mnth_pay_'.$empl_id.'_'.$single['id']];
				$loan_type_id = GetSingleValue('kv_empl_loan_types', 'id', ['allowance_id' => $single['id']]);
				//Re-Pay-Ment
				if(is_array($myloan)) {
					foreach($myloan as $myrow){
						if($myrow['loan_type_id'] == $loan_type_id){	 
						$periods_cot= $_POST[$single_empl['empl_id'].'_'.$single['id']];
						$paid_now  = $myrow['periods_paid'] + $periods_cot;	
							if($paid_now > 0){
							$loan_repay_id[] = Insert('kv_empl_loan_repayment', array('loan_id' => $myrow['id'], 're_pay_date' => date("Y-m-d"), 're_pay_amount' => $loan_id_amount, 'periods_paid' => $paid_now));
							Update('kv_empl_loan', array('id' => $myrow['id']), array('periods_paid' => $paid_now));

							if($myrow['periods'] == $paid_now)
									$sql = "UPDATE ".TB_PREF."kv_empl_loan SET periods_paid = ".db_escape($paid_now).", status = 3 WHERE id = ".db_escape($myrow['id']);
								else
									$sql = "UPDATE ".TB_PREF."kv_empl_loan SET periods_paid = ".db_escape($paid_now)." WHERE id = ".db_escape($myrow['id']);
								//display_notification($sql);
								db_query($sql, _("could not update employee loan"));		
							}
						}
					}
				}
				//Re-Pay-Ment

			}else{
				$jobs_arr[$single['id']]= (input_num($empl_id.$single['id']) ? input_num($empl_id.$single['id']) : 0);
			}
		}
		
		$jobs_arr['loans'] = base64_encode(serialize($loan_id));
		$pay_slip_id = Insert('kv_empl_salary', $jobs_arr);

		if(isset($_POST[$empl_id.'adv_sal']) && $_POST[$empl_id.'adv_sal'] > 0){				
			Update('kv_empl_salary_advance', array('empl_id' =>$empl_id, 'date' => $_POST[$single_empl['empl_id'].'adv_date']), array('inactive' => '1', 'payslip_id' => $pay_slip_id));
			}

			if(isset($paid_now) && $paid_now > 0 && !empty($loan_repay_id)){
				foreach($loan_repay_id as $loan)
					Update('kv_empl_loan_repayment', array('id' => $loan), array('pay_slip_id' => $pay_slip_id));
			}

		$_POST['join_date'] = GetSingleValue('kv_empl_job', 'joining', array('empl_id' => $empl_id));

		ChangeAttendanceInactive($empl_id, sql2date($_POST['join_date']),$_POST['to_a_date']);

					//gl
		if(get_hrm_option('postgl') == 1)
			Direct_gl_entries($pay_slip_id,(isset($_POST[$empl_id.'adv_sal']) ? $_POST[$empl_id.'adv_sal'] :0),$loan_id_amount);
			//gl

		if(input_num($empl_id.'net_pay') < 0 ){
			$month = ($_POST['month'] == 12 ? 1 : $_POST['month']+1 );
			Insert('kv_empl_salary_advance', array('empl_id' => $empl_id, 'payslip_id_adv' => $pay_slip_id, 'month' => $month, 'year' => $_POST['year'], 'amount' => abs(input_num('net_pay')), 'date' =>  array(Today(), 'date'), 'description' => 'Last month Salary of Net Deduction' ) );
		}
		unset($jobs_arr);
	}
	commit_transaction();	
	meta_forward($path_to_root.'/modules/ExtendedHRM/inquires/payroll_history_inquiry.php', "grade=".get_post('grade')."&dept_id=".$_POST['dept_id'].'&month='.$_POST['month'].'&year='.$_POST['year'].'&Added=yes');
}

end_page(); ?>
