<?php
/*--------------------------------------------------\
| Onlinksoft   	|   System   | Alshamsi             |
|---------------------------------------------------|
| For use with:                                    	|
| Onlinksoft Systems Only 							|
| https://www.Onlinksoft.com/  	            		|
| by Dr Abdullah Y.A.M Alshamsi                     |
| Mobile 00967733393330		                    	|
\--------------------------------------------------*/
include_once($path_to_root. '/includes/ui/simple_crud_class.inc');
include_once($path_to_root . "/modules/ExtendedHRM/includes/db/empl_experience_db.inc");

class experience extends simple_crud {
	var $selected_id;
	var $entity;
	var $sub_class;
	var $class;
	
	function __construct($name, $id, $class, $subclass=null) {
		$fields = array('company_name','company_location','department', 'designation','from', 'to');

		parent::__construct($name, $fields);
		$this->class = $class;
		$this->subclass = $subclass;
		$this->entity = $id;
		
	}

	function list_view() {		
		global $Ajax;
		br();
		if(list_updated('empl_id')){
			$this->selected_id =-1;
			$Ajax->activate('experience_edit');
		}
		$experience = get_person_experiences($this->entity);			
		start_table(TABLESTYLE, "width=80%");
		$th = array( _("Company Name"), _("Company Location"), _("Department"), _("Designation"),_("Start Date"), _("End Date"), "", "");	
		table_header($th);		
		foreach($experience as $de) {
			label_cell($de[2]);					
			label_cell($de[3]);
			label_cell($de[4]);
			label_cell($de[5]);			
			label_cell(sql2date($de[6]));		
			label_cell(sql2date($de[7]));					
			edit_button_cell("{$this->name}Edit[{$de[0]}]", _("Edit"));

			// delete button removes only category unless this is the last experience for this experience
			delete_button_cell("{$this->name}Delete[{$de[0]}]", _("Delete"));
			end_row();					
		}
		end_table(1);
	}
	
	function editor_view(){
		br();
		$this->list_view();		
		br(2);
		
		if($this->selected_id != null || $this->selected_id != "") {
			$de = GetRow('kv_empl_experience', array('id' => $this->selected_id));
		
			if($de){
				$_POST['from'] = sql2date($de['s_date']);
				$_POST['to'] = sql2date($de['e_date']);
				$_POST['company_name'] = $de['company_name'];
				$_POST['company_location'] = $de['company_location'];
				$_POST['designation'] = $de['designation'];
				$_POST['department'] = $de['department'];			
			}
		}	
		div_start('experience_edit');
		start_outer_table(TABLESTYLE);

			table_section(1);
			table_section_title(_("Work Experience"));
				text_row(_("Company Name")." :", 'company_name', null, 35, 40);
				text_row(_("Company Location")." :", 'company_location', null, 35, 40);
				text_row(_("Department")." :", 'department', null, 35, 40);
				text_row(_("Designation")." :", 'designation', null, 35, 40);
				date_row(_("From")." :", 'from', null);
				date_row(_("To")." :", 'to', null);			
			end_outer_table(1);
	}

	function _bottom_controls()	{
		$title=false;
		$async='both';
		$base=$this->name;
		$cancel = $async;

		if ($async === 'both') {
			$async = 'default'; $cancel = 'cancel';
		} 
		else if ($async === 'default')
			$cancel = true;
		else if ($async === 'cancel')
			$async = true;
		echo "<center>";

		if ($this->Mode == '' || $this->Mode == 'RESET')
			submit("{$base}NEW", _("Add new"), true, $title, $async);
		else {
			if ($this->Mode == 'NEW' || $this->selected_id==$this->_none)
				
				submit("{$base}ADD", _("Add"), true, $title, $async);
			else {
				submit("{$base}UPDATE[{$this->selected_id}]", _("Update"), true, _("Submit changes"), $async);				
			}
			submit("{$base}RESET", _("Cancel"), true, _("Cancel edition"), $cancel);
		}
		echo "</center>";
		div_end();
	}
	
	function db_insert() {
		$dat = $this->data;
			
		return add_empl_experience($this->entity, $dat['company_name'], $dat['company_location'], $dat['department'], $dat['designation'], $dat['from'], $dat['to']);
	}

	function db_update() {	
		return update_empl_experience($this->entity, $_POST['company_name'], $_POST['company_location'], $_POST['department'], $_POST['designation'], $_POST['from'], $_POST['to'], $this->selected_id);
	}

	function insert_check() {
		if (strlen($_POST['company_name']) == 0) {
			display_error(_("The Company name cannot be empty."));
			set_focus('company_name');
			return false;
		}
		if (strlen($_POST['company_location']) == 0) {
			display_error(_("Company location cannot be empty."));
			set_focus('company_location');
			return false;
		}
		if (strlen($_POST['department']) == 0) {
			display_error(_("Employee department cannot be empty."));
			set_focus('department');
			return false;
		}
		if (strlen($_POST['designation']) == 0) {
			display_error(_("Employee designation cannot be empty."));
			set_focus('designation');
			return false;
		}
		if (!is_date(@$_POST['from'])) {
			display_error(_("Select Employee career start up date."));
			set_focus('from');
			return false;
		}
		return true; 
	}

	function db_read() {
		return GetRow('kv_empl_experience', array('id' => $this->entity));
	}

	function delete_check() {
		return true;
	}
	
	function db_delete() {
		if (delete_empl_experience($this->selected_id, $this->class, $this->entity)) {
			
		}
		return false;
	}
}


class empl_experience extends simple_crud {
	var $selected_id;
	var $entity;
	var $sub_class;
	var $class;
	
	function __construct($name, $id, $class, $subclass=null) {
		$fields = array('company_name','company_location','department', 'designation','from', 'to');

		parent::__construct($name, $fields);
		$this->class = $class;
		$this->subclass = $subclass;
		$this->entity = $id;		
	}

	function list_view() {		
		br();
		$experience = get_person_experiences($this->entity);			
		start_table(TABLESTYLE, "width=80%");
		$th = array( _("Company Name"), _("Company Location"), _("Department"), _("Designation"),_("Start Date"), _("End Date"));	
		table_header($th);		
		foreach($experience as $de) {				
			label_cell($de[2]);					
			label_cell($de[3]);
			label_cell($de[4]);
			label_cell($de[5]);			
			label_cell(sql2date($de[6]));		
			label_cell(sql2date($de[7]));			
			end_row();					
		}
		end_table(1);
	}		
	function _bottom_controls()	{}	
}
?>
