<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/

//--------------------------------------------------------------------------------------
function kv_get_tax_value($allowance_id, $gross_pay_, $year,$frequency){

	$gross_pay = ($gross_pay_/$frequency)*12 ;
	 $sql = "SELECT * FROM ".TB_PREF."kv_empl_taxes WHERE min_sal <= ".db_escape($gross_pay)." AND max_sal >= ".db_escape($gross_pay)." AND year=".db_escape($year)." AND allowance_id=".db_escape($allowance_id)." LIMIT 1" ;
	$result = db_query($sql, _("could not get Tax type"));	
 
	if(db_num_rows($result) > 0 )
		return db_fetch($result);
	else
		return false;
}

function kv_get_tax_for_an_employee($allowance_id, $empl_id, $year, $gross=null, $month=null){	

	if($gross)		 
		$gross_pay_month = $gross;	
	else
		$gross_pay_month =  get_empl_gross_pay($empl_id);

	$months = get_hrm_option('monthsList');
	$monthsList = $months;
	
	if(is_array($monthsList) && in_array((int)$month, $monthsList)){

		$freq = $frequency = get_hrm_option('frequency');

		$frequency--; 
		if($frequency >= 0){	
		
			for($i=1; $i<= $frequency; $i++){				
				$month_to_query = $month-$i;
				if($month_to_query < 1)
					$month_to_query_final = 12 + $month_to_query;
				else
					$month_to_query_final = $month_to_query;	
							
				$gross_pay_mnth = GetSingleValue('kv_empl_salary', 'gross', array('month' => $month_to_query_final, 'year' => $year, 'empl_id' => $empl_id));	
				$gross_pay_month = $gross_pay_month + $gross_pay_mnth;
				
			}
			
			$tax_row = kv_get_tax_value($allowance_id, $gross_pay_month, $year,$frequency+1);		
			
			if(isset($tax_row) && $tax_row != ''){
				if($tax_row['percentage'] > 0){
					if($tax_row['taxable_salary'] > 0){
						$tax_val = ($tax_row['taxable_salary'] /*- $tax_row['min_sal']*/)*($tax_row['percentage']/100)+$tax_row['offset'];
						$tax_val=$freq*($tax_val/12);

					}
					else{
						$tax_val = ($gross_pay_month /*- $tax_row['min_sal']*/)*($tax_row['percentage']/100)+$tax_row['offset'];
						$tax_val=$tax_val/12;
					}
				}elseif($tax_row['offset'] > 0 ){
					$tax_val = $tax_row['offset']/12;				
				} else
					$tax_val = 0;
			} else
				$tax_val = 0;
		} else {
			$tax_val = 0; 
		}
	} else 
		$tax_val = 0;
	return round($tax_val);
}
?>